package com.esv.datacenter.iot.common.util;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Random;

/**
 * @description: 图片验证码工具类
 * @project: base-service
 * @name: com.esv.htwl.base.common.util.CaptchaUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/11 14:18
 * @version:1.0
 */
public class CaptchaUtils {

    /**
     * 验证码字符集
     **/
    private static final char[] chars = {
            '2', '3', '4', '5', '6', '7', '8', '9',
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N',
            'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    /**
     * 字符数量
     **/
    private static final int SIZE = 4;

    /**
     * 干扰线数量
     **/
    private static final int LINES = 5;

    /**
     * 宽度
     **/
    private static final int WIDTH = 80;

    /**
     * 高度
     **/
    private static final int HEIGHT = 30;

    /**
     * 字体大小
     **/
    private static final int FONT_SIZE = 30;

    /**
     * description 创建图片验证码
     * param []
     * return java.lang.Object[]
     * author Administrator
     * createTime 2020/04/11 14:14
     **/
    public static Object[] createCaptchaImage() {
        StringBuffer sb = new StringBuffer();
        // 1.创建空白图片
        BufferedImage image = new BufferedImage(WIDTH, HEIGHT, BufferedImage.TYPE_INT_RGB);
        // 2.获取图片画笔
        Graphics graphic = image.getGraphics();
        // 3.设置画笔颜色
        graphic.setColor(Color.LIGHT_GRAY);
        // 4.绘制矩形背景
        graphic.fillRect(0, 0, WIDTH, HEIGHT);
        // 5.画随机字符
        Random ran = new Random();
        for (int i = 0; i <SIZE; i++) {
            // 取随机字符索引
            int n = ran.nextInt(chars.length);
            // 设置随机颜色
            graphic.setColor(getRandomColor());
            // 设置字体大小
            graphic.setFont(new Font(null, Font.BOLD + Font.ITALIC, FONT_SIZE));
            // 画字符
            graphic.drawString(chars[n] + "", i * WIDTH / SIZE, HEIGHT * 4 / 5);
            // 记录字符
            sb.append(chars[n]);
        }

        // 6.画干扰线
/*        for (int i = 0; i < LINES; i++) {
            // 设置随机颜色
            graphic.setColor(getRandomColor());
            // 随机画线
            graphic.drawLine(ran.nextInt(WIDTH), ran.nextInt(HEIGHT), ran.nextInt(WIDTH), ran.nextInt(HEIGHT));
        }*/

        graphic.dispose();

        // 7.返回验证码和图片
        return new Object[]{sb.toString(), image};
    }

    /**
     * description 获取随机颜色
     * param []
     * return java.awt.Color
     * author Administrator
     * createTime 2020/04/11 14:12
     **/
    private static Color getRandomColor() {
        Random random = new Random();
        Color color = new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        return color;
    }
}
