package com.esv.datacenter.iot.module.omodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.common.exception.EException;
import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.common.util.ReqUtils;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.omodel.dao.ObjectModelDao;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelEntity;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelPropertyEntity;
import com.esv.datacenter.iot.module.omodel.form.ModelPropertyForm;
import com.esv.datacenter.iot.module.omodel.form.ObjectModelForm;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelPropertyService;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service("objectModelService")
public class ObjectModelServiceImpl extends ServiceImpl<ObjectModelDao, ObjectModelEntity> implements ObjectModelService {

    private ObjectModelPropertyService objectModelPropertyService;

    public ObjectModelServiceImpl(ObjectModelPropertyService objectModelPropertyService) {
        this.objectModelPropertyService = objectModelPropertyService;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createObjectModel(ObjectModelForm form) {
        // 1.创建模型
        // 模型名称校验：不能重复
        int modelCount = this.getBaseMapper().selectCount(new LambdaQueryWrapper<ObjectModelEntity>()
                .eq(ObjectModelEntity::getName, form.getName())
                .eq(ObjectModelEntity::getTenantId, ReqUtils.getRequestTenantId()));
        if (0 < modelCount) {
            throw new EException(ECode.PARAM_ERROR.code(), "模型[" + form.getName() + "]已存在");
        }


        ObjectModelEntity modelEntity = new ObjectModelEntity();
        modelEntity.setName(form.getName());
        modelEntity.setDescription(form.getDescription());
        this.getBaseMapper().insert(modelEntity);
        Long modelId = modelEntity.getId();

        // 2.添加模型字段
        List<ModelPropertyForm> propertyList = form.getPropertyList();
        List<ObjectModelPropertyEntity> modelPropertyEntityList = new ArrayList<>();
        for (ModelPropertyForm propertyForm : propertyList) {
            ObjectModelPropertyEntity propertyEntity = new ObjectModelPropertyEntity();
            BeanUtils.copyProperties(propertyForm, propertyEntity);
            propertyEntity.setModelId(modelId);
            modelPropertyEntityList.add(propertyEntity);
        }
        this.objectModelPropertyService.saveBatch(modelPropertyEntityList);
        for (ObjectModelPropertyEntity modelPropertyEntity : modelPropertyEntityList) {
            ObjectModelPropertyEntity entity = new ObjectModelPropertyEntity();
            entity.setId(modelPropertyEntity.getId());
            entity.setSortNum(modelPropertyEntity.getId());
            this.objectModelPropertyService.updateById(entity);
        }

        // 3.创建时序数据库表

        return modelId;
    }

    @Override
    public PageResultVO getModel4Page(ObjectModelForm queryObj) {
        IPage<ObjectModelEntity> page = new Page<>(queryObj.getPageNum(), queryObj.getPageSize());
        this.baseMapper.select4Page(page, queryObj);

        return new PageResultVO(page, page.getRecords());
    }
}

