package com.esv.datacenter.iot.module.omodel.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 物模型属性表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
@Data
@TableName("base_object_model_property")
public class ObjectModelPropertyEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 *
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 模型ID
	 */
	private Long modelId;
	/**
	 * 属性代码
	 */
	private String propertyCode;
	/**
	 * 属性名称
	 */
	private String propertyName;
	/**
	 * 属性类型（字典表）
	 */
	private Integer propertyType;
	/**
	 * 属性默认值
	 */
	private String propertyDefaultValue;
	/**
	 * 属性单位
	 */
	private String propertyUnit;
	/**
	 * 排列序号
	 */
	private Long sortNum;
	/**
	 * 是否删除：0-未删除、1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
