package com.esv.datacenter.iot.module.omodel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.esv.datacenter.iot.common.exception.EException;
import com.esv.datacenter.iot.common.response.EResponse;
import com.esv.datacenter.iot.common.util.ReqUtils;
import com.esv.datacenter.iot.common.validator.groups.ValidatorInsert;
import com.esv.datacenter.iot.common.validator.groups.ValidatorList;
import com.esv.datacenter.iot.module.omodel.form.ModelPropertyForm;
import com.esv.datacenter.iot.module.omodel.form.ObjectModelForm;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @description: 物模型Controller
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/31 14:52
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/model")
@Validated
public class ObjectModelController {

    private ObjectModelService objectModelService;

    public ObjectModelController(ObjectModelService objectModelService) {
        this.objectModelService = objectModelService;
    }

    /**
     * @description 创建模型
     * @param form:
     * @return com.esv.datacenter.iot.common.response.EResponse
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 14:53
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) ObjectModelForm form) throws EException {
        // 参数校验：模型属性
        String[] notBlandParams = new String[]{"propertyCode", "propertyName", "propertyType"};
        List<ModelPropertyForm> propertyList = form.getPropertyList();
        propertyList.forEach(property -> {
            ReqUtils.checkParamsNotBlank(JSON.parseObject(property.toString()), notBlandParams);
        });

        Long id = objectModelService.createObjectModel(form);
        JSONObject data = new JSONObject();
        data.put("id", id);

        return EResponse.ok(data);
    }

    /**
     * @description 分页查询模型列表
     * @param form:
     * @return com.esv.datacenter.iot.common.response.EResponse
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 16:31
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody @Validated(ValidatorList.class) ObjectModelForm form) throws EException {
        return EResponse.ok(objectModelService.getModel4Page(form));
    }
}
