package com.esv.datacenter.iot.module.devicemodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.devicemodel.dto.DeviceInstanceDto;
import com.esv.datacenter.iot.module.devicemodel.entity.DeviceInstanceEntity;
import com.esv.datacenter.iot.module.devicemodel.form.DeviceInstanceForm;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceInstanceVO;

import java.util.List;
import java.util.Map;

/**
 * 设备实例Service
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
public interface DeviceInstanceService extends IService<DeviceInstanceEntity> {

    /**
     * @description 查询指定设备类型ID的设备实例数量
     * @param deviceTypeId:
     * @return int
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 20:25
     **/
    int getInstanceCountByTypeId(Long deviceTypeId);

    /**
     * @description 新增设备实例
     * @param form:
     * @return java.lang.Long
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 10:40
     **/
    Long insertDeviceInstance(DeviceInstanceForm form);

    /**
     * @description 删除设备实例
     * @param id:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 10:49
     **/
    void deleteInstance(Long id);

    /**
     * @description 编辑设备实例信息
     * @param form:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 10:58
     **/
    void updateInstance(DeviceInstanceForm form);

    /**
     * @description 判断是否有效实例ID
     * @param id:
     * @return java.lang.Boolean
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 10:47
     **/
    Boolean isValidId(Long id);

    /**
     * @description 通过ID获取设备实例
     * @param id:
     * @return com.esv.datacenter.iot.module.devicemodel.entity.DeviceInstanceEntity
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 10:47
     **/
    DeviceInstanceEntity getInstanceById(Long id);

    /**
     * @description 分页查询
     * @param form:
     * @return com.esv.datacenter.iot.common.vo.PageResultVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 13:39
     **/
    PageResultVO getInstance4Page(DeviceInstanceForm form);

    /**
     * @description 查询指定设备类型ID的设备实例列表
     * @param deviceTypeId:
     * @return int
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 20:25
     **/
    List<DeviceInstanceVO> getInstanceListByTypeId(Long deviceTypeId);

    /**
     * @description 查询设备类型的实例数量
     * @param deviceTypeId:
     * @return java.util.Map<java.lang.String,java.lang.Long>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/10 17:30
     **/
    Map<String, Long> getInstanceCountByType(Long deviceTypeId);

    /**
     * @description 通过通信ID获取设备实例
     * @param communicationId:
     * @return com.esv.datacenter.iot.module.devicemodel.entity.DeviceInstanceEntity
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/12 13:45
     **/
    DeviceInstanceEntity getInstanceByCommunicationId(String communicationId);

    /**
     * @description 查询设备列表
     * @return java.util.List<com.esv.datacenter.iot.module.devicemodel.dto.DeviceInstanceDto>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/12 15:34
     **/
    List<DeviceInstanceDto> get4List(DeviceInstanceDto dto);

    /**
     * description 根据通信id更新设备在线状态
     * param [communicationIdList]
     * return void
     * author chenfm
     * createTime 2020/8/12 17:37
     **/
    void changeDeviceOnlineState(List<String> communicationIdList);

    /**
     * @description 保存client Mqtt Topic发布/订阅权限
     * @param deviceTypeId:
     * @param deviceInstanceId:
     * @param clientId:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/13 16:44
     **/
    void saveInstanceMqttTopicAuth(Long deviceTypeId, Long deviceInstanceId, String clientId);

}

