package com.esv.datacenter.iot.common.util;

import com.alibaba.fastjson.JSONObject;
import com.esv.datacenter.iot.common.constants.CommonConstants;
import com.esv.datacenter.iot.common.exception.EException;
import com.esv.datacenter.iot.common.response.ECode;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * @description: Http请求工具类
 * @project: freight-base-service
 * @name: com.esv.htwl.base.common.util.ReqUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/26 19:09
 * @version:1.0
 */
public class ReqUtils {

    /**
     * 获得Http客户端的ip
     * @param req
     * @return
     */
    public static String getHttpClientIp(HttpServletRequest req){
        String ip = req.getHeader(CommonConstants.HTTP_HEADER_X_FORWARDED_FOR);
        if(ip == null || ip.length() == 0 || CommonConstants.UNKNOWN_STRING.equalsIgnoreCase(ip)) {
            ip = req.getHeader(CommonConstants.HTTP_HEADER_PROXY_CLIENT_IP);
        }
        if(ip == null || ip.length() == 0 || CommonConstants.UNKNOWN_STRING.equalsIgnoreCase(ip)) {
            ip = req.getHeader(CommonConstants.HTTP_HEADER_WL_PROXY_CLIENT_IP);
        }
        if(ip == null || ip.length() == 0 || CommonConstants.UNKNOWN_STRING.equalsIgnoreCase(ip)) {
            ip = req.getRemoteAddr();
        }
        return ip;
    }

    /**
     * description 校验参数不能为空：key存在、value存在且不为空字符串
     * param [reqJson, params]
     * return void
     * author Administrator
     * createTime 2020/04/17 17:23
     **/
    public static void checkParamsNotBlank(JSONObject reqJson, String[] params) throws EException {
        for (int i = 0; i < params.length; i++) {
            if (StringUtils.isBlank(reqJson.getString(params[i]))) {
                throw new EException(ECode.PARAM_ERROR.code(), "参数"+params[i]+"不能为空");
            }
        }
    }
}
