package com.esv.datacenter.iot.common.vo;

import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.Data;

import java.util.List;

/**
 * @description: 分页查询返回结果VO
 * @project: htwl-base-service
 * @name: com.esv.htwl.base.common.vo.PageResultVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/09 10:01
 * @version:1.0
 */
@Data
public class PageResultVO {

    /**
     * 每页记录条数
     **/
    private Long pageSize;

    /**
     * 当前页码
     **/
    private Long pageNum;

    /**
     * 总记录条数
     **/
    private Long total;

    /**
     * 当前页的记录条数
     **/
    private Long recordSize;

    /**
     * 数据
     **/
    private List<?> records;

    public PageResultVO(IPage page, List<?> records) {
        this.pageSize = page.getSize();
        this.pageNum = page.getCurrent();
        this.total = page.getTotal();
        this.recordSize = Long.parseLong(String.valueOf(page.getRecords().size()));
        this.records = records;
    }
}
