package com.esv.datacenter.iot.module.datamodel.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 数据模型表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
@Data
@TableName("data_model")
public class DataModelEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 模型名称
	 */
	private String name;
	/**
	 * 模型描述
	 */
	private String description;
	/**
	 * 是否删除：0-未删除、1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
