package com.esv.datacenter.iot.module.devicemodel.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.datacenter.iot.module.devicemodel.dto.DeviceInstanceDto;
import com.esv.datacenter.iot.module.devicemodel.entity.DeviceInstanceEntity;
import com.esv.datacenter.iot.module.devicemodel.form.DeviceInstanceForm;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Map;

/**
 * 设备实例表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
@Mapper
public interface DeviceInstanceDao extends BaseMapper<DeviceInstanceEntity> {

    /**
     * @description 分页查询
     * @param page:
     * @param queryObj:
     * @return com.baomidou.mybatisplus.core.metadata.IPage
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 13:37
     **/
    IPage select4Page(IPage page, DeviceInstanceForm queryObj);

    /**
     * @description 查询设备类型的实例数量
     * @param queryObj:
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Long>>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/10 17:28
     **/
    List<Map<String, Long>> selectInstanceCountByType(Map<String, Object> queryObj);

    /**
     * @description 查询设备列表
     * @return java.util.List<com.esv.datacenter.iot.module.devicemodel.dto.DeviceInstanceDto>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/12 15:33
     **/
    List<DeviceInstanceDto> select4List();
	
}
