package com.esv.datacenter.iot.module.dashboard.service.impl;

import com.esv.datacenter.iot.common.component.TimescaleComponent;
import com.esv.datacenter.iot.common.constants.CommonConstants;
import com.esv.datacenter.iot.common.util.SqlUtils;
import com.esv.datacenter.iot.module.dashboard.req.DashboardReq;
import com.esv.datacenter.iot.module.dashboard.req.HistoryDashboardReq;
import com.esv.datacenter.iot.module.dashboard.service.DashboardService;
import com.esv.datacenter.iot.module.dashboard.vo.ModelDataVO;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.dashboard.service.impl.DashboardServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/3 20:24
 * @version: 1.0
 */
@Slf4j
@Service("dashboardService")
public class DashboardServiceImpl implements DashboardService {

    private JdbcTemplate jdbcTemplate;

    @Autowired
    public DashboardServiceImpl(TimescaleComponent timescaleComponent) {
        HikariDataSource dataSource = timescaleComponent.getHikariDataSource();
        jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public List<ModelDataVO> modelData(List<DashboardReq> dashboardReqList) {
        List<ModelDataVO> modelDataVOList = new ArrayList<>();
        for (DashboardReq dashboardReq : dashboardReqList) {
            Long modelId = dashboardReq.getModelId();
            String tableName = CommonConstants.MODEL_DATA_TABLE_PREFIX + modelId;
            String sql = "select time"
                    + SqlUtils.makeSqlParams(dashboardReq.getPropertyCodeList())
                    + " from "
                    + tableName
                    + " where device_id = ?"
                    + " order by time desc limit 100";
            log.info("select modelData sql: {}", sql);
            List<Map<String, Object>> dataList = jdbcTemplate.queryForList(sql, dashboardReq.getDeviceId());
            modelDataVOList.add(new ModelDataVO(modelId, dataList));
        }
        return modelDataVOList;
    }

    @Override
    public List<ModelDataVO> modelHistory(HistoryDashboardReq historyDashboardReq) {
        Timestamp beginTime = new Timestamp(historyDashboardReq.getBeginTime());
        Timestamp endTime = new Timestamp(historyDashboardReq.getEndTime());
        List<DashboardReq> dashboardReqList = historyDashboardReq.getDashboardReqList();
        List<ModelDataVO> modelDataVOList = new ArrayList<>();
        for (DashboardReq dashboardReq : dashboardReqList) {
            Long modelId = dashboardReq.getModelId();
            String tableName = CommonConstants.MODEL_DATA_TABLE_PREFIX + modelId;
            String sql = "select time"
                    + SqlUtils.makeSqlParams(dashboardReq.getPropertyCodeList())
                    + " from "
                    + tableName
                    + " where device_id = ?"
                    + " and (time > ? and time < ?)"
                    + " order by time";
            log.info("select modelData sql: {}", sql);
            List<Map<String, Object>> dataList =
                    jdbcTemplate.queryForList(sql, dashboardReq.getDeviceId(),
                            beginTime, endTime);
            ModelDataVO modelDataVO = new ModelDataVO(modelId, dataList);
            modelDataVOList.add(modelDataVO);
        }
        return modelDataVOList;
    }

}
