package com.esv.datacenter.iot.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.datacenter.iot.feign.EMQFeignService;
import com.esv.datacenter.iot.module.devicemodel.service.DeviceInstanceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.task.DeviceStateScheduleTask
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/12 15:08
 * @version: 1.0
 */
@Slf4j
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
public class DeviceStateScheduleTask {

    private EMQFeignService emqFeignService;

    private DeviceInstanceService deviceInstanceService;

    public DeviceStateScheduleTask(EMQFeignService emqFeignService, DeviceInstanceService deviceInstanceService) {
        this.emqFeignService = emqFeignService;
        this.deviceInstanceService = deviceInstanceService;
    }

    // 直接指定时间间隔: 1分钟
    @Scheduled(fixedRate=60000)
    private void refreshDeviceState() {
        log.info("定时刷新设备在线状态开始, 执行时间: {}", LocalDateTime.now());

        JSONObject jsonObject = emqFeignService.connections();
        log.info("获取emq客户端列表结果: {}", jsonObject.toJSONString());

        if (!jsonObject.containsKey("code") || jsonObject.getInteger("code") != 0) {
            log.error("获取emq客户端列表失败");
            return;
        }

        List<String> clientIdList = new ArrayList<>();
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        for (Object clientObject : jsonArray) {
            JSONObject client = (JSONObject) JSON.toJSON(clientObject);
            clientIdList.add(client.getString("client_id"));
        }

        log.info("clientId list: {}", JSON.toJSONString(clientIdList));
        if (!clientIdList.isEmpty()) {
            deviceInstanceService.changeDeviceOnlineState(clientIdList);
        }
    }

}
