package com.esv.datacenter.iot.module.omodel.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.datacenter.iot.BaseTestController;
import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.module.omodel.form.ModelPropertyForm;
import com.esv.datacenter.iot.module.omodel.form.ObjectModelForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/31 14:54
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class ObjectModelControllerTest extends BaseTestController {

    /**
     * 新增个人承运商
     **/
    @Test
    public void a1_add_success_test() throws Exception {
        String url = "/model/add";

        // 构造数据
        ObjectModelForm form = new ObjectModelForm();
        form.setName("测试模型");
        form.setDescription("这是一个测试模型");
        List<ModelPropertyForm> propertyList = new ArrayList<>();
        ModelPropertyForm modelPropertyForm = new ModelPropertyForm();
        modelPropertyForm.setPropertyCode("id");
        modelPropertyForm.setPropertyName("主键");
        modelPropertyForm.setPropertyType(1);
        propertyList.add(modelPropertyForm);
        form.setPropertyList(propertyList);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }
}
