package com.esv.datacenter.iot.module.dashboard.service.impl;

import com.esv.datacenter.iot.common.component.TimescaleComponent;
import com.esv.datacenter.iot.module.dashboard.req.DashboardReq;
import com.esv.datacenter.iot.module.dashboard.service.DashboardService;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.dashboard.service.impl.DashboardServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/3 20:24
 * @version: 1.0
 */
@Service("dashboardService")
public class DashboardServiceImpl implements DashboardService {

    private TimescaleComponent timescaleComponent;

    @Autowired
    public DashboardServiceImpl(TimescaleComponent timescaleComponent) {
        this.timescaleComponent = timescaleComponent;
    }

    @Override
    public List<Map<String, Object>> modelData(DashboardReq dashboardReq) {
        String tableName = "iot_model_" + dashboardReq.getModelId();
        String sql = "select time"
                + getSqlParams(dashboardReq.getPropertyCodeList(), false)
                + " from "
                + tableName;
        HikariDataSource dataSource = timescaleComponent.getHikariDataSource();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        return jdbcTemplate.queryForList(sql);
    }

    private String getSqlParams(Collection collection, boolean isString) {
        StringBuilder builder = new StringBuilder();
        for (Object key : collection) {
            builder.append(",");
            if (isString) {
                builder.append("'");
            }
            builder.append(key.toString());
            if (isString) {
                builder.append("'");
            }
        }
        return builder.toString();
    }

}
