package com.esv.datacenter.iot.module.devicemodel.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.datacenter.iot.module.devicemodel.dto.DeviceTypeDto;
import com.esv.datacenter.iot.module.devicemodel.entity.DeviceTypeEntity;
import com.esv.datacenter.iot.module.devicemodel.form.DeviceTypeForm;
import org.apache.ibatis.annotations.Mapper;

/**
 * 设备类型表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
@Mapper
public interface DeviceTypeDao extends BaseMapper<DeviceTypeEntity> {

    /**
     * @description 分页查询
     * @param page:
     * @param queryObj:
     * @return com.baomidou.mybatisplus.core.metadata.IPage
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 9:34
     **/
    IPage select4Page(IPage page, DeviceTypeForm queryObj);

    /**
     * description 查询设备类型详情
     * param [id]
     * return com.esv.datacenter.iot.module.devicemodel.dto.DeviceTypeDto
     * author chenfm
     * createTime 2020/8/13 16:16
     **/
    DeviceTypeDto deviceTypeDetail(Long id);


}
