package com.esv.datacenter.iot.module.omodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelPropertyEntity;
import com.esv.datacenter.iot.module.omodel.form.ModelPropertyForm;
import com.esv.datacenter.iot.module.omodel.vo.ModelPropertyVO;

import java.util.List;

/**
 * 物模型属性表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
public interface ObjectModelPropertyService extends IService<ObjectModelPropertyEntity> {

    /**
     * @description 逻辑删除指定模型的所有属性
     * @param entity:
     * @return java.lang.Integer
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 13:28
     **/
    Integer logicDeleteModelProperty(ObjectModelPropertyEntity entity);

    /**
     * @description 获取指定模型的属性列表
     * @param modelId:
     * @return java.util.List<com.esv.datacenter.iot.module.omodel.vo.ModelPropertyVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:32
     **/
    List<ModelPropertyVO> getModelPropertyList(Long modelId);

    /**
     * @description 保存模型属性
     * @param modelId:
     * @param propertyList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:42
     **/
    void saveModelProperty(Long modelId, List<ModelPropertyForm> propertyList);

    /**
     * @description 校验属性
     * @param propertyList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 19:59
     **/
    void checkModelProperty(List<ModelPropertyForm> propertyList);

    /**
     * @description 属性代码转换为小写
     * @param propertyList:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 20:40
     **/
    void propertyCode2Lowercase(List<ModelPropertyForm> propertyList);

}

