package com.esv.datacenter.iot.module.omodel.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelEntity;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelInstanceEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.datacenter.iot.module.omodel.form.ModelInstanceForm;
import com.esv.datacenter.iot.module.omodel.form.ObjectModelForm;
import org.apache.ibatis.annotations.Mapper;

/**
 * 物模型实例表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
@Mapper
public interface ObjectModelInstanceDao extends BaseMapper<ObjectModelInstanceEntity> {

    /**
     * @description 分页查询
     * @param page:
     * @param queryObj:
     * @return com.baomidou.mybatisplus.core.metadata.IPage
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 16:24
     **/
    IPage select4Page(IPage page, ModelInstanceForm queryObj);

    /**
     * @description 逻辑删除模型实例
     * @param entity:
     * @return java.lang.Integer
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 10:11
     **/
    Integer logicDeleteInstance(ObjectModelInstanceEntity entity);
	
}
