package com.esv.superhive.iot.module.devicemodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.superhive.iot.module.datamodel.entity.DataModelEntity;
import com.esv.superhive.iot.module.devicemodel.entity.DeviceDataMapEntity;

import java.util.List;

/**
 * 设备类型-数据模型映射Service
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
public interface DeviceDataMapService extends IService<DeviceDataMapEntity> {

    /**
     * @description 统计指定数据模型的使用数量
     * @param dataModelId:
     * @return int
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 16:25
     **/
    int getCountByDataModelId(Long dataModelId);

    /**
     * @description 通过设备类型ID删除映射记录
     * @param deviceTypeId:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 20:30
     **/
    void deleteByDeviceTypeId(Long deviceTypeId);

    /**
     * @description 保存设备类型与数据模型的映射记录
     * @param deviceTypeId:
     * @param dataModelIds:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 14:18
     **/
    void saveDeviceDataMap(Long deviceTypeId, String dataModelIds);

    /**
     * @description 通过设备类型ID获取对应的数据模型列表
     * @param deviceTypeId:
     * @return java.util.List<com.esv.superhive.iot.module.datamodel.entity.DataModelEntity>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 14:26
     **/
    List<DataModelEntity> getDataModelByDeviceTypeId(Long deviceTypeId);

}

