package com.esv.superhive.iot.common.exception;

/**
 * @description: 自定义业务异常
 * @project: SpringCloudTemplate
 * @name: com.esv.springcloud.template.common.exception.EException
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/03/12 17:21
 * @version:1.0
 */
public class EException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private int code = 500;

    private String message;

    public EException(String message) {
        super(message);
        this.message = message;
    }

    public EException(String message, Throwable e) {
        super(message, e);
        this.message = message;
    }

    public EException(int code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }

    public EException(int code, String message, Throwable e) {
        super(message, e);
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
