package com.esv.superhive.iot.common.component;

import com.esv.superhive.iot.module.datamodel.service.DataModelAlarmRuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @project: htwl-base-service
 * @name: com.esv.htwl.base.common.component.ApplicationLoadRunner
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/28 14:33
 * @version:1.0
 */
@Slf4j
@Component
public class ApplicationLoadRunner implements ApplicationRunner {

    @Value("${spring.application.name}")
    private String applicationName;

    @Autowired
    private DataModelAlarmRuleService dataModelAlarmRuleService;

    @Override
    public void run(ApplicationArguments var) {
        log.info("-------------------- [{}]初始化完成 --------------------", applicationName);

        // 初始化缓存数据模型告警规则
        try {
            dataModelAlarmRuleService.cacheInitAlarmRule();
            log.info("-------------------- 缓存数据模型告警规则初始化成功 --------------------");
        } catch (Exception e) {
            log.error("-------------------- 缓存数据模型告警规则初始化失败 --------------------");
            log.error(e.getMessage(), e);
        }
    }

}