package com.esv.superhive.iot.common.component;

import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/13 16:07
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class MqttClientAuthComponentTest {

    @Autowired
    private MqttClientAuthComponent mqttClientAuthComponent;

    @Test
    public void saveClientAcl_test() {
        List<MqttAcl> mqttAclList = new ArrayList<>();

        MqttAcl mqttAcl = new MqttAcl();
        mqttAcl.setAllow(1);
        mqttAcl.setClientid(String.valueOf(System.currentTimeMillis()));
        mqttAcl.setAccess(2);
        mqttAcl.setTopic("$esv/iot/1/2/3/data/upload");
        mqttAclList.add(mqttAcl);

        mqttClientAuthComponent.saveClientAcl(mqttAclList);
    }

    @Test
    public void getClientTopicInfo_test() {
        mqttClientAuthComponent.getClientTopicInfo("1597307123829");
    }
}
