package com.esv.superhive.iot.module.datamodel.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.superhive.iot.module.datamodel.entity.DataModelEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.superhive.iot.module.datamodel.form.DataModelForm;
import org.apache.ibatis.annotations.Mapper;

/**
 * 数据模型Dao
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
@Mapper
public interface DataModelDao extends BaseMapper<DataModelEntity> {

    /**
     * @description 分页查询
     * @param page: 
     * @param queryObj: 
     * @return com.baomidou.mybatisplus.core.metadata.IPage
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 16:24
     **/
    IPage select4Page(IPage page, DataModelForm queryObj);

    /**
     * @description 逻辑删除指定模型
     * @param entity:
     * @return java.lang.Integer
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 14:06
     **/
    Integer logicDeleteModel(DataModelEntity entity);
	
}
