package com.esv.superhive.iot.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.superhive.iot.common.constants.CommonConstants;
import com.esv.superhive.iot.common.exception.EException;
import lombok.extern.slf4j.Slf4j;

/**
 * @description: Feign工具类
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 18:05
 * @version:1.0
 */
@Slf4j
public class FeignUtils {

    /**
     * description 获取Feign调用结果数据
     * param [resultJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/04/17 18:12
     **/
    public static JSONObject getFeignResultData(JSONObject resultJson) throws EException {
        String result = resultJson.toJSONString();
        log.info(result);
        if (CommonConstants.FEIGN_RESULT_SUCCESS == resultJson.getIntValue(CommonConstants.FEIGN_RESULT_CODE)) {
            return resultJson.getJSONObject(CommonConstants.FEIGN_RESULT_DATA);
        } else {
            throw new EException(resultJson.getIntValue(CommonConstants.FEIGN_RESULT_CODE), resultJson.getString(CommonConstants.FEIGN_RESULT_MESSAGE));
        }
    }

    /**
     * @description 获取Feign调用结果数据
     * @param resultJson:
     * @return com.alibaba.fastjson.JSONArray
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 16:34
     **/
    public static JSONArray getFeignResultDataList(JSONObject resultJson) throws EException {
        String result = resultJson.toJSONString();
        log.info(result);
        if (CommonConstants.FEIGN_RESULT_SUCCESS == resultJson.getIntValue(CommonConstants.FEIGN_RESULT_CODE)) {
            return resultJson.getJSONArray(CommonConstants.FEIGN_RESULT_DATA);
        } else {
            throw new EException(resultJson.getIntValue(CommonConstants.FEIGN_RESULT_CODE), resultJson.getString(CommonConstants.FEIGN_RESULT_MESSAGE));
        }
    }

}
