package com.esv.superhive.iot.common.component;

import lombok.Data;

/**
 * @description: 数据源配置
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/27 13:48
 * @version:1.0
 */
@Data
public class DataSourceConfig {

    /**
     *
     */
    private String jdbcUrl;
    /**
     *
     */
    private String driverClassName;
    /**
     *
     */
    private String username;
    /**
     *
     */
    private String password;
    /**
     *
     */
    private String validationQuery;
    /**
     * 数据库连接超时时间，默认30秒，即30000
     */
    private Long connectionTimeout;
    /**
     * 连接池中维护的最小空闲连接数
     */
    private Integer minimumIdle;
    /**
     * 连接池中最大连接数，包括闲置和使用中的连接
     */
    private Integer maximumPoolSize;
    /**
     * connection在连接池中的存活时间，默认是1800000，即30分钟。如果设置为0，表示存活时间无限大
     */
    private Long maxLifetime;

    public DataSourceConfig(String jdbcUrl, String driverClassName, String username, String password) {
        this.jdbcUrl = jdbcUrl;
        this.driverClassName = driverClassName;
        this.username = username;
        this.password = password;
    }

    public DataSourceConfig(String jdbcUrl, String driverClassName, String username, String password,
                            String validationQuery, Long connectionTimeout, Integer minimumIdle,
                            Integer maximumPoolSize, Long maxLifetime) {
        this.jdbcUrl = jdbcUrl;
        this.driverClassName = driverClassName;
        this.username = username;
        this.password = password;
        this.validationQuery = validationQuery;
        this.connectionTimeout = connectionTimeout;
        this.minimumIdle = minimumIdle;
        this.maximumPoolSize = maximumPoolSize;
        this.maxLifetime = maxLifetime;
    }
}
