package com.esv.datacenter.iot.module.datamodel.controller;

import com.esv.datacenter.iot.common.exception.EException;
import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.common.response.EResponse;
import com.esv.datacenter.iot.common.validator.groups.ValidatorInsert;
import com.esv.datacenter.iot.common.validator.groups.ValidatorList;
import com.esv.datacenter.iot.module.datamodel.form.DataModelAlarmRuleForm;
import com.esv.datacenter.iot.module.datamodel.service.DataModelAlarmRuleService;
import com.esv.datacenter.iot.module.datamodel.service.DataModelService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/05 16:27
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/dataModel/alarmRule")
@Validated
public class DataModelAlarmRuleController {

    private DataModelService dataModelService;
    private DataModelAlarmRuleService dataModelAlarmRuleService;

    public DataModelAlarmRuleController(DataModelService dataModelService, DataModelAlarmRuleService dataModelAlarmRuleService) {
        this.dataModelService = dataModelService;
        this.dataModelAlarmRuleService = dataModelAlarmRuleService;
    }

    /**
     * @description 保存告警规则
     * @param form:
     * @return com.esv.datacenter.iot.common.response.EResponse
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/05 17:08
     **/
    @PostMapping("/save")
    public EResponse save(@RequestBody @Validated(ValidatorInsert.class) DataModelAlarmRuleForm form) throws EException {
        // 模型ID有效性校验
        if (!dataModelService.isModelExits(form.getModelId())) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "无效的模型ID值");
        }

        // 保存告警规则
        dataModelAlarmRuleService.saveAlarmRule(form);

        return EResponse.ok();
    }

    /**
     * @description 获取指定数据模型的告警规则列表
     * @param form:
     * @return com.esv.datacenter.iot.common.response.EResponse
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 9:16
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody @Validated(ValidatorList.class) DataModelAlarmRuleForm form) throws EException {
        // 模型ID有效性校验
        if (!dataModelService.isModelExits(form.getModelId())) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "无效的模型ID值");
        }

        return EResponse.ok(dataModelAlarmRuleService.getAlarmRuleList(form.getModelId()));
    }
}
