package com.esv.datacenter.iot.module.omodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.common.em.DbDeletedEnum;
import com.esv.datacenter.iot.module.omodel.dao.ObjectModelPropertyDao;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelPropertyEntity;
import com.esv.datacenter.iot.module.omodel.form.ModelPropertyForm;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelPropertyService;
import com.esv.datacenter.iot.module.omodel.vo.ModelPropertyVO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service("objectModelPropertyService")
public class ObjectModelPropertyServiceImpl extends ServiceImpl<ObjectModelPropertyDao, ObjectModelPropertyEntity> implements ObjectModelPropertyService {

    @Override
    public Integer logicDeleteModelProperty(ObjectModelPropertyEntity entity) {
        return this.getBaseMapper().logicDeleteModelProperty(entity);
    }

    @Override
    public List<ModelPropertyVO> getModelPropertyList(Long modelId) {
        List<ObjectModelPropertyEntity> entityList = this.getBaseMapper()
                .selectList(new LambdaQueryWrapper<ObjectModelPropertyEntity>()
                        .eq(ObjectModelPropertyEntity::getModelId, modelId)
                        .eq(ObjectModelPropertyEntity::getDeleted, DbDeletedEnum.NO.getCode())
                        .orderByAsc(ObjectModelPropertyEntity::getSortNum));

        List<ModelPropertyVO> voList = new ArrayList<>();
        for (ObjectModelPropertyEntity entity : entityList) {
            ModelPropertyVO vo = new ModelPropertyVO();
            BeanUtils.copyProperties(entity, vo);
            vo.setCreateTime(entity.getCreateTime().getTime());
            vo.setUpdateTime(entity.getUpdateTime().getTime());
            voList.add(vo);
        }

        return voList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveModelProperty(Long modelId, List<ModelPropertyForm> propertyList) {
        // 删除模型属性
        ObjectModelPropertyEntity propertyEntity = new ObjectModelPropertyEntity();
        propertyEntity.setDeleted(DbDeletedEnum.YES.getCode());
        propertyEntity.setModelId(modelId);
        this.logicDeleteModelProperty(propertyEntity);

        // 新增模型属性
        List<ObjectModelPropertyEntity> modelPropertyEntityList = new ArrayList<>();
        for (ModelPropertyForm propertyForm : propertyList) {
            ObjectModelPropertyEntity entity = new ObjectModelPropertyEntity();
            BeanUtils.copyProperties(propertyForm, entity);
            entity.setModelId(modelId);
            modelPropertyEntityList.add(entity);
        }
        this.saveBatch(modelPropertyEntityList);

        // 更新属性排序值
        for (ObjectModelPropertyEntity modelPropertyEntity : modelPropertyEntityList) {
            ObjectModelPropertyEntity entity = new ObjectModelPropertyEntity();
            entity.setId(modelPropertyEntity.getId());
            entity.setSortNum(modelPropertyEntity.getId());
            this.updateById(entity);
        }
    }
}