package com.esv.datacenter.iot.module.dashboard.controller;

import com.esv.datacenter.iot.module.dashboard.req.DashboardReq;
import com.esv.datacenter.iot.module.dashboard.service.DashboardService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.dashboard.controller.DashboardController
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/7/31 17:53
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("dashboard")
public class DashboardController {

    private DashboardService dashboardService;

    @Autowired
    public DashboardController(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    @PostMapping("modelData")
    public List<Map<String, Object>> modelData(@RequestBody DashboardReq dashboardReq) {
        return dashboardService.modelData(dashboardReq);
    }

}
