package com.esv.datacenter.iot.module.alarm.controller;

import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.common.response.EResponse;
import com.esv.datacenter.iot.common.validator.groups.ValidatorList;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.alarm.dto.DeviceDataAlarmDTO;
import com.esv.datacenter.iot.module.alarm.form.AlarmListForm;
import com.esv.datacenter.iot.module.alarm.service.DeviceDataAlarmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.alarm.controller.DeviceDataAlarmController
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/7 14:21
 * @version: 1.0
 */
@RestController
@RequestMapping("alarm/show")
public class DeviceDataAlarmController {

    private DeviceDataAlarmService deviceDataAlarmService;

    @Autowired
    public DeviceDataAlarmController(DeviceDataAlarmService deviceDataAlarmService) {
        this.deviceDataAlarmService = deviceDataAlarmService;
    }

    /**
     * description 告警查询
     * param [alarmListForm]
     * return com.esv.datacenter.iot.common.response.EResponse<java.util.List<com.esv.datacenter.iot.module.alarm.dto.DeviceDataAlarmDTO>>
     * author chenfm
     * createTime 2020/8/7 16:59
     **/
    @PostMapping("list")
    public EResponse<PageResultVO> list(@RequestBody @Validated(ValidatorList.class) AlarmListForm alarmListForm) {
        PageResultVO pageResultVO = deviceDataAlarmService.alarmList(alarmListForm);
        return EResponse.ok(pageResultVO);
    }

    /**
     * description 告警详情
     * param [id]
     * return com.esv.datacenter.iot.common.response.EResponse<com.esv.datacenter.iot.module.alarm.dto.DeviceDataAlarmDTO>
     * author chenfm
     * createTime 2020/8/7 17:00
     **/
    @GetMapping("detail")
    public EResponse<DeviceDataAlarmDTO> detail(@RequestParam(value = "id") Long id) {
        DeviceDataAlarmDTO deviceDataAlarmDTO = deviceDataAlarmService.alarmDetail(id);
        if (deviceDataAlarmDTO == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }
        return EResponse.ok(deviceDataAlarmDTO);
    }

}
