package com.esv.datacenter.iot.module.dashboard.service.impl;

import com.esv.datacenter.iot.common.component.TimescaleComponent;
import com.esv.datacenter.iot.module.dashboard.req.DashboardReq;
import com.esv.datacenter.iot.module.dashboard.service.DashboardService;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.dashboard.service.impl.DashboardServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/3 20:24
 * @version: 1.0
 */
@Slf4j
@Service("dashboardService")
public class DashboardServiceImpl implements DashboardService {

    private TimescaleComponent timescaleComponent;

    private JdbcTemplate jdbcTemplate = null;

    @Autowired
    public DashboardServiceImpl(TimescaleComponent timescaleComponent) {
        this.timescaleComponent = timescaleComponent;
    }

    @Override
    public List<Map<String, Object>> modelData(DashboardReq dashboardReq) {
        String tableName = "iot_model_" + dashboardReq.getModelId();
        String sql = "select time"
                + getSqlParams(dashboardReq.getPropertyCodeList(), false)
                + " from "
                + tableName
                + " where instance_id = ?"
                + " order by time desc limit 100";
        log.info("select modelData sql: {}", sql);
        if (jdbcTemplate == null) {
            HikariDataSource dataSource = timescaleComponent.getHikariDataSource();
            jdbcTemplate = new JdbcTemplate(dataSource);
        }
        return jdbcTemplate.queryForList(sql, dashboardReq.getInstanceId());
    }

    private String getSqlParams(Collection collection, boolean isString) {
        StringBuilder builder = new StringBuilder();
        for (Object key : collection) {
            builder.append(",");
            if (isString) {
                builder.append("'");
            }
            builder.append(key.toString());
            if (isString) {
                builder.append("'");
            }
        }
        return builder.toString();
    }

}
