package com.esv.datacenter.iot.module.devicemodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.common.exception.EException;
import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelEntity;
import com.esv.datacenter.iot.module.datamodel.vo.DataModelBriefVO;
import com.esv.datacenter.iot.module.devicemodel.dao.DeviceTypeDao;
import com.esv.datacenter.iot.module.devicemodel.entity.DeviceTypeEntity;
import com.esv.datacenter.iot.module.devicemodel.form.DeviceTypeForm;
import com.esv.datacenter.iot.module.devicemodel.service.DeviceDataMapService;
import com.esv.datacenter.iot.module.devicemodel.service.DeviceTypeService;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceTypeBriefVO;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceTypeVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


@Service("deviceTypeService")
public class DeviceTypeServiceImpl extends ServiceImpl<DeviceTypeDao, DeviceTypeEntity> implements DeviceTypeService {

    @Autowired
    private DeviceDataMapService deviceDataMapService;

    @Override
    public Long insertDeviceType(DeviceTypeForm form) {
        // 判断设备名称是否有重复
        int count = this.getBaseMapper().selectCount(new LambdaQueryWrapper<DeviceTypeEntity>()
                .eq(DeviceTypeEntity::getName, form.getName()));
        if (0 < count) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "设备类型[" + form.getName() + "]已存在");
        }

        DeviceTypeEntity entity = new DeviceTypeEntity();
        BeanUtils.copyProperties(form, entity);
        this.getBaseMapper().insert(entity);
        return entity.getId();
    }

    @Override
    public void updateDeviceType(DeviceTypeForm form) {
        // 判断设备名称是否有重复
        int count = this.getBaseMapper().selectCount(new LambdaQueryWrapper<DeviceTypeEntity>()
                .ne(DeviceTypeEntity::getId, form.getId())
                .eq(DeviceTypeEntity::getName, form.getName()));
        if (0 < count) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "设备类型[" + form.getName() + "]已存在");
        }

        DeviceTypeEntity entity = new DeviceTypeEntity();
        BeanUtils.copyProperties(form, entity);
        this.getBaseMapper().updateById(entity);
    }

    @Override
    public DeviceTypeEntity getDeviceTypeById(Long id) {
        return this.getBaseMapper().selectById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDeviceType(Long id) {
        // 删除设备类型记录
        this.getBaseMapper().deleteById(id);

        // 删除设备类型与数据类型对应的映射记录
        this.deviceDataMapService.deleteByDeviceTypeId(id);
    }

    @Override
    public PageResultVO getType4Page(DeviceTypeForm form) {
        IPage<DeviceTypeEntity> page = new Page<>(form.getPageNum(), form.getPageSize());
        this.baseMapper.select4Page(page, form);

        List<DeviceTypeEntity> entityList = page.getRecords();
        List<DeviceTypeVO> voList = new ArrayList<>();
        for (DeviceTypeEntity entity : entityList) {
            DeviceTypeVO vo = new DeviceTypeVO();
            BeanUtils.copyProperties(entity, vo);
            vo.setCreateTime(entity.getCreateTime().getTime());
            vo.setUpdateTime(entity.getUpdateTime().getTime());
            voList.add(vo);
        }

        return new PageResultVO(page, voList);
    }

    @Override
    public Boolean isValidTypeId(Long id) {
        DeviceTypeEntity entity = this.getDeviceTypeById(id);
        if (Objects.isNull(entity)) {
            return false;
        } else {
            return true;
        }
    }

    @Override
    public List<DeviceTypeBriefVO> getTypeList() {
        List<DeviceTypeEntity> entityList = this.getBaseMapper().selectList(new LambdaQueryWrapper<DeviceTypeEntity>()
                .orderByAsc(DeviceTypeEntity::getName));
        List<DeviceTypeBriefVO> voList = new ArrayList<>();
        for (DeviceTypeEntity entity : entityList) {
            DeviceTypeBriefVO vo = new DeviceTypeBriefVO();
            BeanUtils.copyProperties(entity, vo);
            voList.add(vo);
        }

        return voList;
    }

    @Override
    public List<DataModelBriefVO> getDataModelByDeviceTypeId(Long deviceTypeId) {
        List<DataModelEntity> entityList = deviceDataMapService.getDataModelByDeviceTypeId(deviceTypeId);

        List<DataModelBriefVO> voList = new ArrayList<>();
        for (DataModelEntity entity : entityList) {
            DataModelBriefVO vo = new DataModelBriefVO();
            BeanUtils.copyProperties(entity, vo);
            voList.add(vo);
        }

        return voList;
    }
}