package com.esv.datacenter.iot.module.datamodel.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/01 10:20
 * @version:1.0
 */
@Data
public class DataModelPropertyVO {

    /**
     *
     */
    @TableId
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 模型ID
     */
    private Long modelId;
    /**
     * 属性代码
     */
    private String propertyCode;
    /**
     * 属性名称
     */
    private String propertyName;
    /**
     * 属性类型（字典表）
     */
    private Integer propertyType;
    /**
     * 属性默认值
     */
    private String propertyDefaultValue;
    /**
     * 属性单位
     */
    private String propertyUnit;
    /**
     * 排列序号
     */
    private Long sortNum;
    /**
     * 是否删除：0-未删除、1-已删除
     */
    @TableLogic
    private Boolean deleted;
    /**
     * 创建者
     */
    @TableField(fill = FieldFill.INSERT)
    private String createUser;
    /**
     * 修改者
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String updateUser;
    /**
     * 创建时间
     */
    private Long createTime;
    /**
     * 修改时间
     */
    private Long updateTime;
}
