package com.esv.datacenter.iot.common.response;

/**
 * @description: 系统响应码
 * @project: SpringCloudTemplate
 * @name: com.esv.springcloud.template.common.response.ECode
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/03/12 17:34
 * @version:1.0
 */
public class ECode {

    public static final ECode SUCCESS = new ECode(200, "success");
    public static final ECode ACCESS_DENIED = new ECode(401, "没有访问权限");
    public static final ECode SERVER_ERROR = new ECode(500, "服务内部错误");
    public static final ECode SERVICE_UNAVAILABLE = new ECode(503, "服务限流，暂不可用");
    public static final ECode PARAM_ERROR = new ECode(600, "参数不合法");
    public static final ECode TOKEN_INVALID = new ECode(601, "无效的Token");
    public static final ECode TOKEN_EXPIRED = new ECode(602, "Token已过期");
    public static final ECode BIZ_PARAM_ERROR = new ECode(1000, "业务参数错误");

    public static final ECode BATCHID_FORMATTOR_ERROR = new ECode(11001, "时间格式错误");
    public static final ECode BATCHID_LENTGH_ERROR = new ECode(11001, "长度错误");

    public ECode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private int code;

    private String message;

    public int code() {
        return code;
    }
    public String message() {
        return message;
    }

}
