package com.esv.datacenter.iot.module.datamodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelAlarmRuleEntity;
import com.esv.datacenter.iot.module.datamodel.form.DataModelAlarmRuleForm;
import com.esv.datacenter.iot.module.datamodel.vo.AlarmRuleItemVO;

import java.util.List;

/**
 * 数据模型告警规则Service
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-05 16:23:06
 */
public interface DataModelAlarmRuleService extends IService<DataModelAlarmRuleEntity> {

    /**
     * @description 保存数据模型告警规则
     * @param form:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/05 16:38
     **/
    void saveAlarmRule(DataModelAlarmRuleForm form);

    /**
     * @description 获取指定数据模型的告警规则列表
     * @param modelId:
     * @return java.util.List<com.esv.datacenter.iot.module.datamodel.vo.AlarmRuleItemVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 9:11
     **/
    List<AlarmRuleItemVO> getAlarmRuleList(Long modelId);

}

