import sys
import math
import psycopg2
import numpy as np
from scipy.fftpack import fft,ifft


np.set_printoptions(suppress=True)
np.set_printoptions(threshold=np.inf)


def search_data(host, port, database, user, password, table_name, column_name, time):
    # database，user，password，host，port分别对应要连接的PostgreSQL数据库的数据库名、数据库用户名、用户密码、主机、端口信息，请根据具体情况自行修改
    conn = psycopg2.connect(database=database, user=user, password=password, host=host, port=port)
    cur = conn.cursor()

    # 执行查询命令  1597916863.951
    sql = 'SELECT sampling_rate, ' + column_name + ' FROM ' + table_name + ' where time = to_timestamp(' + time + ');'
    print(sql)
    cur.execute(sql)

    # 获取结果集的每一行
    rows = cur.fetchall()
    print('查询结果数: ', len(rows))
    row1 = rows[0]
    samplingRate = row1[0]
    displacement = row1[1]

    # 关闭连接
    conn.close()
    return samplingRate, displacement


def computeRadian(opp, limb):
    if limb < 0:
        return math.atan(opp / limb) + np.pi
    else:
        return math.atan(opp / limb)


def calc_fft(sampling_rate, displacement):
    #采样点选择1400个，因为设置的信号频率分量最高为600赫兹，根据采样定理知采样频率要大于信号频率2倍，所以这里设置采样频率为1400赫兹（即一秒内有1400个采样点，一样意思的）
    length = len(displacement) / (sampling_rate * 1000000)
    x = np.linspace(0., float(length), len(displacement))

    #设置需要采样的信号，频率分量有180，390和600
    # y=0.1 + 0.01*np.cos(2*np.pi*50*x-np.pi*60/180) + 5*np.cos(2*np.pi*100*x+np.pi*90/180) + 20*np.cos(2*np.pi*80*x+np.pi*90/180) + 24*np.cos(2*np.pi*40*x+np.pi*90/180)
    y = displacement

    yy = fft(y)  # 快速傅里叶变换
    yreal = yy.real  # 获取实数部分
    yimag = yy.imag  # 获取虚数部分

    yf = abs(fft(y))  # 取绝对值
    halfsize = int(len(x) / 2)
    yf2 = yf[range(halfsize)]  # 由于对称性，只取一半区间
    yf3 = yf2 / sum(yf2)  # 归一化

    result_list = []
    throshold = float(0.1 / halfsize)
    if yf3[0] > throshold:
        frequency = yf3[0] * sum(yf2) / halfsize / 2
        radian = computeRadian(yimag[0], yreal[0])
        result_list.append([0, frequency, radian])

    for i in range(1, len(yf3) - 1):
        if (yf3[i] - yf3[i - 1]) > throshold and (yf3[i] - yf3[i + 1]) > throshold:
            frequency = yf3[i] * sum(yf2) / halfsize
            radian = computeRadian(yimag[i], yreal[i])
            result_list.append([i, frequency, radian])

    xf = np.arange(len(y))      # 频率
    xf1 = xf
    xf2 = xf[range(int(len(x)/2))]  # 取一半区间
    return result_list, xf2, yf3


def print_array(array, fixed):
    i = 0
    for x in array:
        i += 1
        if (fixed):
            x = format(x, '.4f')
        if (i < len(array)):
            print(x, end=',')
        else:
            print(x, end='\n')


if __name__ == '__main__':
    host = sys.argv[1]
    port = sys.argv[2]
    database = sys.argv[3]
    user = sys.argv[4]
    password = sys.argv[5]
    table_name = sys.argv[6]
    column_name = sys.argv[7]
    time = sys.argv[8]
    print('开始调用python ', host, port, database, user, password, table_name, column_name, time)

    (sampling_rate, displacement) = search_data(host, port, database, user, password, table_name, column_name, time)
    (result_list, xf, yf) = calc_fft(sampling_rate, displacement)
    print('result_list:', result_list)
    print_array(xf, False)
    print_array(yf, True)