package com.esv.datacenter.iot.module.devicemodel.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/14 10:49
 * @version:1.0
 */
@Data
public class DeviceInstanceAccessInfoVO {

    /**
     * 设备实例ID
     */
    private Long instanceId;
    /**
     * 设备实例名称
     */
    private String instanceName;
    /**
     * 通信ID
     **/
    private String communicationId;
    /**
     * 设备类型ID
     */
    private Long deviceTypeId;
    /**
     * 设备类型名称
     */
    private String deviceTypeName;

    /**
     * Mqtt Topic信息列表
     **/
    List<DeviceInstanceMqttTopicInfoVO> mqttTopicInfoVOList;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
