package com.esv.datacenter.iot.module.dashboard.vo;

import lombok.Data;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.dashboard.vo.FunctionVO
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/21 13:45
 * @version: 1.0
 */
@Data
public class FunctionVO implements Comparable<FunctionVO> {

    /**
     * 振幅
     **/
    private String amplitude;

    /**
     * 频率
     **/
    private String frequency;

    /**
     * 相位
     **/
    private String phase;

    @Override
    public int compareTo(FunctionVO functionVO) {
        if (Double.parseDouble(functionVO.getFrequency()) == 0) {
            return 1;
        }
        if (Double.parseDouble(this.getAmplitude()) > Double.parseDouble(functionVO.getAmplitude())) {
            return -1;
        } else if (Double.parseDouble(this.getAmplitude()) < Double.parseDouble(functionVO.getAmplitude())) {
            return 1;
        } else {
            return 0;
        }
    }
}
