package com.esv.datacenter.iot.module.dashboard.service.impl;

import com.esv.datacenter.iot.common.constants.CommonConstants;
import com.esv.datacenter.iot.module.dashboard.req.FrequencyDomainReq;
import com.esv.datacenter.iot.module.dashboard.service.PythonService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.dashboard.service.impl.PythonServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/21 11:41
 * @version: 1.0
 */
@Slf4j
@Service("pythonService")
public class PythonServiceImpl implements PythonService {

    @Value("${timescale.data-source.jdbc-url}")
    private String timeScaleUrl;

    @Value("${timescale.data-source.username}")
    private String timeScaleUser;

    @Value("${timescale.data-source.password}")
    private String timeScalePassword;

    @Value("${python.path.frequency}")
    private String pythonFrequencyPath;

    @Override
    public List<String> calcFrequency(FrequencyDomainReq frequencyDomainReq) {
        // jdbc:postgresql://192.168.31.248:5432/iot
        String urlStr = timeScaleUrl.replaceFirst("jdbc:postgresql://", "");
        String host = urlStr.split(":")[0];
        String port = urlStr.split(":")[1].split("/")[0];
        String database = urlStr.split(":")[1].split("/")[1];

        String tableName = CommonConstants.MODEL_DATA_TABLE_PREFIX + frequencyDomainReq.getModelId();
        String columnName = frequencyDomainReq.getPropertyCode();
        double time = frequencyDomainReq.getTime() / 1000.0;

        List<String> resultList = new ArrayList<>();
        String pythonPath = "python3";
        String[] arguments = new String[] {pythonPath, pythonFrequencyPath,
                host, port, database, timeScaleUser, timeScalePassword, tableName, columnName, String.valueOf(time)};
        try {
            Process process = Runtime.getRuntime().exec(arguments);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream(),"GBK");
            BufferedReader in = new BufferedReader(inputStreamReader);
            BufferedReader bufrError = new BufferedReader(new InputStreamReader(process.getErrorStream(), "GBK"));
            String line = null;
            boolean record = false;
            while ((line = in.readLine()) != null) {
                log.info(line);
                if (line.startsWith("result_list:")) {
                    record = true;
                    line = line.replaceFirst("result_list:", "");
                }
                if (record) {
                    resultList.add(line);
                }
            }
            in.close();

            //输出错误信息
            String error = null;
            while ((error = bufrError.readLine()) != null) {
                log.error(error);
            }
            bufrError.close();

            //java代码中的process.waitFor()返回值为0表示我们调用python脚本成功，
            //返回值为1表示调用python脚本失败，这和我们通常意义上见到的0与1定义正好相反
            int re = process.waitFor();
            log.info("python脚本调用结果: {}", re);

        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return resultList;
    }

}
