package com.esv.datacenter.iot.module.devicemodel.service.impl;

import com.esv.datacenter.iot.common.component.TimescaleComponent;
import com.esv.datacenter.iot.common.constants.CommonConstants;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelEntity;
import com.esv.datacenter.iot.module.datamodel.service.DataModelPropertyService;
import com.esv.datacenter.iot.module.datamodel.service.DataModelService;
import com.esv.datacenter.iot.module.datamodel.vo.DataModelPropertyVO;
import com.esv.datacenter.iot.module.devicemodel.service.DeviceDataService;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceDataPropertyVO;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceDataVO;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.devicemodel.service.impl.DeviceDataServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/13 17:12
 * @version: 1.0
 */
@Slf4j
@Service("deviceDataService")
public class DeviceDataServiceImpl implements DeviceDataService {

    private DataModelService dataModelService;

    private DataModelPropertyService dataModelPropertyService;

    private JdbcTemplate jdbcTemplate;

    @Autowired
    public DeviceDataServiceImpl(DataModelService dataModelService,
                                 DataModelPropertyService dataModelPropertyService,
                                 TimescaleComponent timescaleComponent) {
        this.dataModelService = dataModelService;
        this.dataModelPropertyService = dataModelPropertyService;
        HikariDataSource dataSource = timescaleComponent.getHikariDataSource();
        jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public DeviceDataVO currentData(Long deviceId, Long dataModelId) {
        DataModelEntity dataModelEntity = dataModelService.getModelInfo(dataModelId);
        if (dataModelEntity == null) {
            return null;
        }
        DeviceDataVO deviceDataVO = new DeviceDataVO();
        BeanUtils.copyProperties(dataModelEntity, deviceDataVO);

        Map<String, Object> dataMap = selectCurrentData(deviceId, dataModelId);
        if (dataMap != null && dataMap.containsKey("time")) {
            deviceDataVO.setReportTime((Date) dataMap.get("time"));
        }

        List<DataModelPropertyVO> propertyList = dataModelPropertyService.getModelPropertyList(dataModelId);
        if (propertyList != null && !propertyList.isEmpty()) {
            List<DeviceDataPropertyVO> list = new ArrayList<>(propertyList.size());
//            List<String> columnNames = new ArrayList<>();
//            propertyList.forEach(v -> columnNames.add(v.getPropertyCode()));

            for (DataModelPropertyVO dataModelPropertyVO : propertyList) {
                DeviceDataPropertyVO deviceDataPropertyVO = new DeviceDataPropertyVO();
                BeanUtils.copyProperties(dataModelPropertyVO, deviceDataPropertyVO);
                String propertyCode = deviceDataPropertyVO.getPropertyCode();
                // 获取最新数据
                if (dataMap != null && dataMap.containsKey(propertyCode)) {
                    String propertyValue = String.valueOf(dataMap.get(propertyCode));
                    deviceDataPropertyVO.setPropertyValue(propertyValue);
                }
                // 加入到返回结果集
                list.add(deviceDataPropertyVO);
            }
            deviceDataVO.setPropertyList(list);
        }

        return deviceDataVO;
    }

    private Map<String, Object> selectCurrentData(Long deviceId, Long dataModelId) {
        String tableName = CommonConstants.MODEL_DATA_TABLE_PREFIX + dataModelId;
        String sql = "select * from "
                + tableName
                + " where device_id = ?"
                + " order by time desc limit 1";
        try {
            return jdbcTemplate.queryForMap(sql, deviceId);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

}
