package com.esv.datacenter.iot.module.devicemodel.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 设备实例表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
@Data
@TableName("device_instance")
public class DeviceInstanceEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 设备类型ID
	 */
	private Long deviceTypeId;
	/**
	 * 设备名称
	 */
	private String name;
	/**
	 * 设备描述
	 */
	private String description;
	/**
	 * 设备业务ID
	 */
	private String businessId;
	/**
	 * 设备型号
	 */
	private String deviceModel;
	/**
	 * 通信ID
	 **/
	private String communicationId;
	/**
	 * 在线状态
	 **/
	private Integer onlineState;
	/**
	 * 在线状态更新时间
	 **/
	private Date onlineUpdateTime;

	/**
	 * 是否删除：0-未删除、1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
