package com.esv.datacenter.iot.module.datamodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.common.util.ReqUtils;
import com.esv.datacenter.iot.module.datamodel.dao.DataModelAlarmRuleDao;
import com.esv.datacenter.iot.module.datamodel.entity.DataModelAlarmRuleEntity;
import com.esv.datacenter.iot.module.datamodel.form.AlarmRuleItemForm;
import com.esv.datacenter.iot.module.datamodel.form.DataModelAlarmRuleForm;
import com.esv.datacenter.iot.module.datamodel.service.DataModelAlarmRuleService;
import com.esv.datacenter.iot.module.datamodel.vo.AlarmRuleItemVO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service("dataModelAlarmRuleService")
public class DataModelAlarmRuleServiceImpl extends ServiceImpl<DataModelAlarmRuleDao, DataModelAlarmRuleEntity> implements DataModelAlarmRuleService {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveAlarmRule(DataModelAlarmRuleForm form) {
        // 删除模型告警规则
        Long modelId = form.getModelId();
        this.getBaseMapper().delete(new LambdaQueryWrapper<DataModelAlarmRuleEntity>().eq(DataModelAlarmRuleEntity::getModelId, modelId));

        // 新增模型告警规则
        String[] notBlandParams = new String[]{"propertyId", "ruleExpression", "alarmLevel", "threshold"};
        List<AlarmRuleItemForm> alarmRuleItemList = form.getAlarmRuleItemList();
        for (AlarmRuleItemForm ruleItemForm : alarmRuleItemList) {
            // 告警规则必填校验
            ReqUtils.checkParamsNotBlank(JSON.parseObject(ruleItemForm.toString()), notBlandParams);

            DataModelAlarmRuleEntity entity = new DataModelAlarmRuleEntity();
            BeanUtils.copyProperties(ruleItemForm, entity);
            entity.setModelId(form.getModelId());
            this.getBaseMapper().insert(entity);

            // 更新排序
            DataModelAlarmRuleEntity sortEntity = new DataModelAlarmRuleEntity();
            sortEntity.setId(entity.getId());
            sortEntity.setSortNum(entity.getId());
            this.getBaseMapper().updateById(sortEntity);
        }
    }

    @Override
    public List<AlarmRuleItemVO> getAlarmRuleList(Long modelId) {
        List<DataModelAlarmRuleEntity> entityList = this.getBaseMapper().selectList(new LambdaQueryWrapper<DataModelAlarmRuleEntity>()
                .eq(DataModelAlarmRuleEntity::getModelId, modelId)
                .orderByAsc(DataModelAlarmRuleEntity::getSortNum));

        List<AlarmRuleItemVO> voList = new ArrayList<>();
        for (DataModelAlarmRuleEntity entity : entityList) {
            AlarmRuleItemVO vo = new AlarmRuleItemVO();
            BeanUtils.copyProperties(entity, vo);
            voList.add(vo);
        }

        return voList;
    }
}