package com.esv.datacenter.iot.module.alarm.dto;

import com.esv.datacenter.iot.module.alarm.entity.DeviceDataAlarmEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description:
 * @project: datacenter-iot-service
 * @name: com.esv.datacenter.iot.module.alarm.dto.DeviceDataAlarmDTO
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/8/7 14:19
 * @version: 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DeviceDataAlarmDTO extends DeviceDataAlarmEntity {

    /**
     * 模型ID
     */
    private Long deviceTypeId;
    /**
     * 模型名称
     */
    private String deviceTypeName;
    /**
     * 实例名称
     */
    private String deviceName;
    /**
     * 实例描述
     */
    private String deviceDescription;
    /**
     * 模型名称
     */
    private String dataModelName;
    /**
     * 属性代码
     */
    private String propertyCode;
    /**
     * 属性名称
     */
    private String propertyName;
    /**
     * 判定规则代码（字典表）
     */
    private Integer ruleExpression;
    /**
     * 告警等级（字典表）
     */
    private Integer alarmLevel;
    /**
     * 阈值
     */
    private String threshold;

}
