package com.esv.datacenter.iot.module.omodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelInstanceEntity;
import com.esv.datacenter.iot.module.omodel.form.ModelInstanceForm;
import com.esv.datacenter.iot.module.omodel.vo.ModelInstanceDetailVO;
import com.esv.datacenter.iot.module.omodel.vo.ModelInstanceVO;

import java.util.List;

/**
 * 物模型实例表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
public interface ObjectModelInstanceService extends IService<ObjectModelInstanceEntity> {

    /**
     * @description 获取指定模型的实例列表
     * @param modelId:
     * @return java.util.List<com.esv.datacenter.iot.module.omodel.vo.ModelInstanceVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/01 13:37
     **/
    List<ModelInstanceVO> getModelInstanceList(Long modelId);

    /**
     * @description 分页查询模型实例列表
     * @param queryObj:
     * @return com.esv.datacenter.iot.common.vo.PageResultVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/07/31 16:26
     **/
    PageResultVO getModelInstance4Page(ModelInstanceForm queryObj);

    /**
     * @description 创建模型实例
     * @param form:
     * @return java.lang.Long
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 10:22
     **/
    Long createModelInstance(ModelInstanceForm form);

    /**
     * @description 更新模型实例
     * @param form:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 11:02
     **/
    void updateModelInstance(ModelInstanceForm form);

    /**
     * @description 删除模型实例
     * @param id:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 11:23
     **/
    void deleteModelInstance(Long id);

    /**
     * @description 判断模型实例是否存在
     * @param id:
     * @return java.lang.Boolean
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 11:06
     **/
    Boolean isModelInstanceExits(Long id);

    /**
     * @description 获取模型实例详情
     * @param id:
     * @return com.esv.datacenter.iot.module.omodel.vo.ModelInstanceDetailVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/03 11:30
     **/
    ModelInstanceDetailVO getModelInstanceDetail(Long id);

}

