package com.esv.datacenter.iot.module.omodel.form;

import com.esv.datacenter.iot.common.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/07/31 14:44
 * @version:1.0
 */
@Data
public class ModelInstanceForm {

    /**
     *
     */
    @NotNull(message = "[模型实例ID]不能为空", groups = {ValidatorUpdate.class, ValidatorDetail.class, ValidatorDelete.class})
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 模型ID
     */
    @NotNull(message = "[模型ID]不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    private Long modelId;
    /**
     * 实例名称
     */
    @Length(max = 50, message = "[实例名称]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "[实例名称]不能为空", groups = {ValidatorInsert.class})
    private String instanceName;
    /**
     * 实例描述
     */
    @Length(max = 200, message = "[实例描述]长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "[实例描述]不能为空", groups = {ValidatorInsert.class})
    private String description;
    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
