package com.esv.datacenter.iot.module.omodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.module.omodel.dao.InstanceTopicDao;
import com.esv.datacenter.iot.module.omodel.entity.InstanceTopicEntity;
import com.esv.datacenter.iot.module.omodel.service.InstanceTopicService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;


@Service("instanceTopicService")
@RefreshScope
public class InstanceTopicServiceImpl extends ServiceImpl<InstanceTopicDao, InstanceTopicEntity> implements InstanceTopicService {

    private static final String TOPIC_PREFIX = "$esv/iot/";

    @Override
    public void insertTopic(Long modelId, Long instanceId) {
        String topic = TOPIC_PREFIX + modelId + "/" + instanceId + "/data/upload";
        InstanceTopicEntity entity = new InstanceTopicEntity();
        entity.setModelId(modelId);
        entity.setInstanceId(instanceId);
        entity.setTopic(topic);
        this.getBaseMapper().insert(entity);
    }

    @Override
    public void deleteTopic(Long instanceId) {
        this.getBaseMapper().delete(new LambdaQueryWrapper<InstanceTopicEntity>().eq(InstanceTopicEntity::getInstanceId, instanceId));
    }

}