package com.esv.datacenter.iot.module.devicemodel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.datamodel.vo.DataModelBriefVO;
import com.esv.datacenter.iot.module.datamodel.vo.DataModelDetailVO;
import com.esv.datacenter.iot.module.devicemodel.entity.DeviceTypeEntity;
import com.esv.datacenter.iot.module.devicemodel.form.DeviceTypeForm;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceTypeBriefVO;
import com.esv.datacenter.iot.module.devicemodel.vo.DeviceTypeStatisticsVO;
import lombok.Data;

import java.util.List;

/**
 * 设备类型Service
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
public interface DeviceTypeService extends IService<DeviceTypeEntity> {

    /**
     * @description 新增设备类型
     * @param form:
     * @return java.lang.Long
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 19:55
     **/
    Long insertDeviceType(DeviceTypeForm form);

    /**
     * @description 更新设备类型
     * @param form:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 20:08
     **/
    void updateDeviceType(DeviceTypeForm form);

    /**
     * @description 通过设备类型ID查询记录
     * @param id:
     * @return com.esv.datacenter.iot.module.devicemodel.entity.DeviceTypeEntity
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 20:22
     **/
    DeviceTypeEntity getDeviceTypeById(Long id);

    /**
     * @description 删除设备类型
     * @param id:
     * @return void
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/06 20:24
     **/
    void deleteDeviceType(Long id);

    /**
     * @description 分页查询
     * @param form:
     * @return com.esv.datacenter.iot.common.vo.PageResultVO
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 9:35
     **/
    PageResultVO getType4Page(DeviceTypeForm form);

    /**
     * @description 是否有效的设备类型ID
     * @param id:
     * @return java.lang.Boolean
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 9:48
     **/
    Boolean isValidTypeId(Long id);

    /**
     * @description 获取设备类型列表
     * @return java.util.List<com.esv.datacenter.iot.module.devicemodel.vo.DeviceTypeBriefVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 9:54
     **/
    List<DeviceTypeBriefVO> getTypeList();

    /**
     * @description 通过设备类型ID获取对应的数据模型列表
     * @param deviceTypeId:
     * @return java.util.List<com.esv.datacenter.iot.module.datamodel.vo.DataModelDetailVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/07 14:34
     **/
    List<DataModelDetailVO> getDataModelByDeviceTypeId(Long deviceTypeId);

    /**
     * @description 获取设备类型对应的实例数量统计
     * @return java.util.List<com.esv.datacenter.iot.module.devicemodel.vo.DeviceTypeStatisticsVO>
     * @author huangChaobin@esvtek.com
     * @createTime 2020/08/12 15:06
     **/
    List<DeviceTypeStatisticsVO> getDeviceTypeStatistics();

}

