package com.esv.datacenter.iot.common.component;

import com.esv.datacenter.iot.module.omodel.dto.ModelAndInstanceDto;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelEntity;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelPropertyEntity;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/03 16:15
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class TimescaleComponentTest {

    @Autowired
    private TimescaleComponent timescaleComponent;

    @Test
    public void createTable_test() {
        Long modelId = 999L;
        ModelAndInstanceDto modelAndInstanceDto = new ModelAndInstanceDto();

        ObjectModelEntity objectModelEntity = new ObjectModelEntity();
        objectModelEntity.setId(modelId);
        modelAndInstanceDto.setObjectModelEntity(objectModelEntity);

        List<ObjectModelPropertyEntity> objectModelPropertyEntityList = new ArrayList<>();
        ObjectModelPropertyEntity objectModelPropertyEntity = new ObjectModelPropertyEntity();
        objectModelPropertyEntity.setPropertyCode("temp");
        objectModelPropertyEntity.setPropertyType(2);
        objectModelPropertyEntityList.add(objectModelPropertyEntity);
        modelAndInstanceDto.setObjectModelPropertyEntityList(objectModelPropertyEntityList);

        Boolean result = timescaleComponent.createTable(modelAndInstanceDto);
        log.info(String.valueOf(result));
    }

    @Test
    public void dropTable_test() {
        Long modelId = 999L;
        Boolean result = timescaleComponent.dropTable(modelId);
        log.info(String.valueOf(result));
    }

}
