package com.esv.datacenter.iot.module.omodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.iot.common.em.DbDeletedEnum;
import com.esv.datacenter.iot.common.exception.EException;
import com.esv.datacenter.iot.common.response.ECode;
import com.esv.datacenter.iot.common.vo.PageResultVO;
import com.esv.datacenter.iot.module.omodel.dao.ObjectModelInstanceDao;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelEntity;
import com.esv.datacenter.iot.module.omodel.entity.ObjectModelInstanceEntity;
import com.esv.datacenter.iot.module.omodel.form.ModelInstanceForm;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelInstanceService;
import com.esv.datacenter.iot.module.omodel.service.ObjectModelService;
import com.esv.datacenter.iot.module.omodel.vo.ModelInstanceDetailVO;
import com.esv.datacenter.iot.module.omodel.vo.ModelInstanceVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service("objectModelInstanceService")
public class ObjectModelInstanceServiceImpl extends ServiceImpl<ObjectModelInstanceDao, ObjectModelInstanceEntity> implements ObjectModelInstanceService {

    @Autowired
    ObjectModelService objectModelService;

    @Override
    public List<ModelInstanceVO> getModelInstanceList(Long modelId) {
        List<ObjectModelInstanceEntity> entityList = this.getBaseMapper().selectList(new LambdaQueryWrapper<ObjectModelInstanceEntity>()
                .eq(ObjectModelInstanceEntity::getDeleted, DbDeletedEnum.NO.getCode())
                .eq(ObjectModelInstanceEntity::getModelId, modelId)
                .orderByAsc(ObjectModelInstanceEntity::getInstanceName));
        List<ModelInstanceVO> voList = new ArrayList<>();
        for (ObjectModelInstanceEntity entity : entityList) {
            ModelInstanceVO vo = new ModelInstanceVO();
            BeanUtils.copyProperties(entity, vo);
            vo.setCreateTime(entity.getCreateTime().getTime());
            vo.setUpdateTime(entity.getUpdateTime().getTime());
            voList.add(vo);
        }

        return voList;
    }

    @Override
    public PageResultVO getModelInstance4Page(ModelInstanceForm queryObj) {
        IPage<ObjectModelInstanceEntity> page = new Page<>(queryObj.getPageNum(), queryObj.getPageSize());
        this.baseMapper.select4Page(page, queryObj);

        List<ObjectModelInstanceEntity> entityList = page.getRecords();
        List<ModelInstanceVO> voList = new ArrayList<>();
        for (ObjectModelInstanceEntity entity : entityList) {
            ModelInstanceVO vo = new ModelInstanceVO();
            BeanUtils.copyProperties(entity, vo);
            vo.setCreateTime(entity.getCreateTime().getTime());
            vo.setUpdateTime(entity.getUpdateTime().getTime());
            voList.add(vo);
        }

        return new PageResultVO(page, voList);
    }

    @Override
    public Long createModelInstance(ModelInstanceForm form) {
        // 模型实例名称校验
        int instanceCount = this.getBaseMapper().selectCount(new LambdaQueryWrapper<ObjectModelInstanceEntity>()
                .eq(ObjectModelInstanceEntity::getModelId, form.getModelId())
                .eq(ObjectModelInstanceEntity::getInstanceName, form.getInstanceName())
                .eq(ObjectModelInstanceEntity::getDeleted, DbDeletedEnum.NO.getCode()));
        if (0 < instanceCount) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "实例名称[" + form.getInstanceName() + "]已存在");
        }

        // 新增模型实例
        ObjectModelInstanceEntity entity = new ObjectModelInstanceEntity();
        BeanUtils.copyProperties(form, entity);
        this.getBaseMapper().insert(entity);

        return entity.getId();
    }

    @Override
    public void updateModelInstance(ModelInstanceForm form) {
        // 模型实例名称校验：不能重复
        int count = this.getBaseMapper().selectCount(new LambdaQueryWrapper<ObjectModelInstanceEntity>()
                .eq(ObjectModelInstanceEntity::getModelId, form.getModelId())
                .eq(ObjectModelInstanceEntity::getInstanceName, form.getInstanceName())
                .eq(ObjectModelInstanceEntity::getDeleted, DbDeletedEnum.NO.getCode())
                .ne(ObjectModelInstanceEntity::getId, form.getId()));
        if (0 < count) {
            if (0 < count) {
                throw new EException(ECode.BIZ_PARAM_ERROR.code(), "实例名称[" + form.getInstanceName() + "]已存在");
            }
        }

        ObjectModelInstanceEntity entity = new ObjectModelInstanceEntity();
        entity.setId(form.getId());
        entity.setInstanceName(form.getInstanceName());
        entity.setDescription(form.getDescription());
        this.getBaseMapper().updateById(entity);
    }

    @Override
    public void deleteModelInstance(Long id) {
        this.getBaseMapper().deleteById(id);

        // TODO，删除时序数据
    }

    @Override
    public Boolean isModelInstanceExits(Long id) {
        int count = this.getBaseMapper().selectCount(new LambdaQueryWrapper<ObjectModelInstanceEntity>()
                .eq(ObjectModelInstanceEntity::getId, id));
        if (0 == count) {
            return false;
        } else {
            return true;
        }
    }

    @Override
    public ModelInstanceDetailVO getModelInstanceDetail(Long id) {
        ModelInstanceDetailVO vo = new ModelInstanceDetailVO();
        ObjectModelInstanceEntity instanceEntity = this.getBaseMapper().selectById(id);
        if (null == instanceEntity) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "无效的模型实例id值");
        } else {
            BeanUtils.copyProperties(instanceEntity, vo);
            vo.setCreateTime(instanceEntity.getCreateTime().getTime());
            vo.setUpdateTime(instanceEntity.getUpdateTime().getTime());
        }

        ObjectModelEntity modelEntity = objectModelService.getModelInfo(instanceEntity.getModelId());
        if (null == modelEntity) {
            throw new EException(ECode.BIZ_PARAM_ERROR.code(), "该实例未查询到有效模型");
        } else {
            vo.setModelName(modelEntity.getName());
            vo.setModelDescription(modelEntity.getDescription());
        }

        return vo;
    }
}