package com.esv.datacenter.iot.config.mybatis;

import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.esv.datacenter.iot.common.util.ReqUtils;
import com.esv.gateway.common.DataPermsType;
import com.esv.gateway.common.GatewayHeaders;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.schema.Column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @description:
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 13:35
 * @version:1.0
 */
public class DataPermHandler implements TenantHandler {

    /**
     * 不需要数据权限查询的表
     **/
    private final List<String> filterTableNames = Arrays.asList("data_model_alarm_rule");

    @Override
    public Expression getTenantId(boolean where) {
        String dataPerm = ReqUtils.getRequestHeader(GatewayHeaders.DATA_PERM);
        //这里只是演示切换单个tenantId和多个tenantId
        final boolean multipleTenantIds = DataPermsType.DATA_PERM_DEPARTMENT.equals(dataPerm);
        //具体场景，可以根据情况来拼接
        if (where && multipleTenantIds) {
            //演示如何实现tenant_id in (1,2)
            return multipleTenantIdCondition();
        } else {
            return singleTenantIdCondition();
        }
    }

    // 获取tenantId
    private Expression singleTenantIdCondition() {
        String tenantId = ReqUtils.getRequestHeader(GatewayHeaders.TENANT_ID);
        return new LongValue(tenantId);
    }

    // 获取departmentId
    private Expression multipleTenantIdCondition() {
        String departmentChildren = ReqUtils.getRequestHeader(GatewayHeaders.DEPARTMENT_CHILDREN);
        final InExpression inExpression = new InExpression();
        inExpression.setLeftExpression(new Column(getTenantIdColumn()));
        final ExpressionList itemsList = new ExpressionList();
        final List<Expression> inValues = new ArrayList<>();
        for (String departmentId : departmentChildren.split(",")) {
            inValues.add(new LongValue(departmentId));
        }
        itemsList.setExpressions(inValues);
        inExpression.setRightItemsList(itemsList);
        return inExpression;
    }

    @Override
    public String getTenantIdColumn() {
        String dataPerm = ReqUtils.getRequestHeader(GatewayHeaders.DATA_PERM);
        //这里只是演示切换单个tenantId和多个tenantId
        final boolean multipleTenantIds = DataPermsType.DATA_PERM_DEPARTMENT.equals(dataPerm);
        if (multipleTenantIds) {
            return "department_id";
        }
        return "tenant_id";
    }

    /**
     * description 判断是否过滤表
     * param [tableName]
     * return boolean
     * author chenfm
     * createTime 2020/4/8 9:31
     **/
    @Override
    public boolean doTableFilter(String tableName) {
        // 只有查询时添加条件
        if (tableName.endsWith("|select")) {
            tableName = tableName.replace("|select", "");
        } else {
            return true;
        }
        if (filterTableNames.contains(tableName)) {
            return true;
        }
        // 全局数据权限不加入条件
        String dataPerm = ReqUtils.getRequestHeader(GatewayHeaders.DATA_PERM);

        if (DataPermsType.DATA_PERM_ALL.equals(dataPerm)) {
            return true;
        }
        return false;
    }
}
