package com.esv.datacenter.iot.module.devicemodel.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 设备类型-数据模型映射表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-08-06 16:15:13
 */
@Data
@TableName("device_data_map")
public class DeviceDataMapEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 设备类型ID
	 */
	private Long deviceTypeId;
	/**
	 * 数据模型ID
	 */
	private Long dataModelId;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
