package com.esv.datacenter.iot.module.datamodel.form;

import com.esv.datacenter.iot.common.validator.groups.ValidatorInsert;
import com.esv.datacenter.iot.common.validator.groups.ValidatorList;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @description:
 * @author: huangchaobin@esvtek.com
 * @createTime: 2020/08/05 16:29
 * @version:1.0
 */
@Data
public class DataModelAlarmRuleForm {

    /**
     * 数据模型ID
     */
    @NotNull(message = "[模型ID]不能为空", groups = {ValidatorInsert.class, ValidatorList.class})
    private Long modelId;
    /**
     * 告警规则列表
     */
    @NotNull(message = "[告警规则]不能为空", groups = {ValidatorInsert.class})
    private List<AlarmRuleItemForm> alarmRuleItemList;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
