package com.esv.datacenter.iot.module.datamodel.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Date;

/**
 * 数据模型属性表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-07-31 13:35:49
 */
@Data
@TableName("data_model_property")
public class DataModelPropertyEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 *
	 */
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 模型ID
	 */
	private Long modelId;
	/**
	 * 属性代码
	 */
	private String propertyCode;
	/**
	 * 属性名称
	 */
	private String propertyName;
	/**
	 * 属性类型（字典表）
	 */
	private Integer propertyType;
	/**
	 * 属性默认值
	 */
	private String propertyDefaultValue;
	/**
	 * 属性单位
	 */
	private String propertyUnit;
	/**
	 * 排列序号
	 */
	private Long sortNum;
	/**
	 * 是否删除：0-未删除、1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	private String createUser;
	/**
	 * 修改者
	 */
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
